package com.bokesoft.yes.meta.persist.dom.commondef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.IconDisplayMode;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.commondef.MetaOperation;

/**
 * 窗口操作对象在保存和载入时的相关动作
 * 
 * @author chenzs
 * @since YES1.0
 */
public class MetaOperationExtAction extends BaseDomAction<MetaOperation> {

	@Override
	public void save(Document document, Element element, MetaOperation meta, int runType) {
		
	}

	@Override
	public void load(Document document, Element element, MetaOperation meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, null));
		meta.setCaptionEn(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN, null));
		meta.setEnable(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE, null));
		meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, null));
		meta.setEnableDependency(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, null));
		meta.setVisibleDependency(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, null));
		meta.setRefKey(DomHelper.readAttr(element, MetaConstants.OPERATION_REFKEY, null));
		meta.setTag(DomHelper.readAttr(element, MetaConstants.COMMON_TAG, null));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, null));
		meta.setExpand(DomHelper.readBool(element, MetaConstants.OPERATION_EXPAND, null));
		meta.setExpandSource(DomHelper.readAttr(element, MetaConstants.OPERATION_EXPAND_SOURCE, null));
		meta.setManaged(DomHelper.readBool(element, MetaConstants.OPERATION_MANAGED, null));
		meta.setShortCuts(DomHelper.readAttr(element, MetaConstants.OPERATION_SHORTCUTS, null));
		meta.setCssClass(DomHelper.readAttr(element, MetaConstants.OPERATION_CSSCLASS, null));
		meta.setNeedAccessLog(DomHelper.readBool(element, MetaConstants.OPERATION_NEEDACCESSLOG, null));
		meta.setIconCode(DomHelper.readAttr(element, MetaConstants.COMMON_ICON_CODE, null));
		String displayMode = DomHelper.readAttr(element, MetaConstants.ICON_DISPLAY_MODE, null);
		if (displayMode != null) {
			meta.setDisplayMode(IconDisplayMode.parse(displayMode));
		}
		meta.setTCode(DomHelper.readAttr(element, MetaConstants.OPERATION_TCODE, null));
		meta.setActivity(DomHelper.readAttr(element, MetaConstants.OPERATION_ACTIVITY, null));
		meta.setTransfer(DomHelper.readBool(element, MetaConstants.OPERATION_ISTRANSFER, null));
	}

}
