package com.bokesoft.yes.meta.persist.dom.commondef;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.common.MetaFieldLabelAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaFieldLabelCollectionAction;
import com.bokesoft.yigo.meta.common.MetaFieldLabel;
import com.bokesoft.yigo.meta.common.MetaFieldLabelCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElement;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementCollection;
import com.bokesoft.yigo.meta.dataelement.MetaDataElementDef;

public class MetaDataElementDefActionMap extends MetaActionMap {
	private MetaDataElementDefActionMap() {
		super();
	}
	
	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] {
				{ MetaDataElementDef.TAG_NAME, new MetaDataElementDefAction() },
				{ MetaDataElementCollection.TAG_NAME, new MetaDataElementCollectionAction() },
				{ MetaDataElement.TAG_NAME, new MetaDataElementAction() },
                { MetaFieldLabel.TAG_NAME, new MetaFieldLabelAction() },
                { MetaFieldLabelCollection.TAG_NAME, new MetaFieldLabelCollectionAction() },
		};
	}

	private static MetaDataElementDefActionMap instance = null;
	public static MetaDataElementDefActionMap getInstance() {
		if ( instance == null ) {
			instance = new MetaDataElementDefActionMap();
		}
		return instance;
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}
}
