package com.bokesoft.yes.meta.persist.dom.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaCustomCondition;

public class MetaCustomConditionAction extends BaseDomAction<MetaCustomCondition> {

	@Override
	public void load(Document document, Element element, MetaCustomCondition meta, int runType) {
		meta.setCondition(DomHelper.readAttr(element, MetaConstants.CUSTOM_CONDITION_CONDITION, ""));
		meta.setFilter(DomHelper.readAttr(element, MetaConstants.CUSTOM_CONDITION_FILTER, ""));
		meta.setSeperator(DomHelper.readAttr(element, MetaConstants.CONDITION_SEPERATOR, ","));
		meta.setMultiPara(DomHelper.readAttr(element, MetaConstants.CONDITION_MULTIPARA, false));
	}

	@Override
	public void save(Document document, Element element, MetaCustomCondition meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.CUSTOM_CONDITION_CONDITION, meta.getCondition(), "");
		DomHelper.writeAttr(element, MetaConstants.CUSTOM_CONDITION_FILTER, meta.getFilter(), "");
		DomHelper.writeAttr(element, MetaConstants.CONDITION_SEPERATOR, meta.getSeperator(), ",");
		DomHelper.writeAttr(element, MetaConstants.CONDITION_MULTIPARA, meta.getMultiPara(), false);
	}

}
