package com.bokesoft.yes.meta.persist.dom.charging;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yigo.meta.charging.MetaChargingPara;
import com.bokesoft.yigo.meta.charging.MetaChargingRule;
import com.bokesoft.yigo.meta.charging.MetaChargingRuleCollection;
import com.bokesoft.yigo.meta.charging.MetaChargingRuleCondition;
import com.bokesoft.yigo.meta.charging.MetaChargingRuleExpression;
import com.bokesoft.yigo.meta.charging.MetaChargingRuleGroup;
import com.bokesoft.yigo.meta.charging.MetaChargingTargetField;
import com.bokesoft.yigo.meta.charging.MetaChargingTargetObject;

public class MetaChargingRuleGroupActionMap extends MetaActionMap {

	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][] {
			{ MetaChargingRule.TAG_NAME, new MetaChargingRuleAction() },
			{ MetaChargingRuleCollection.TAG_NAME, new MetaChargingRuleCollectionAction() },
			{ MetaChargingPara.TAG_NAME, new MetaChargingParaAction() },
			{ MetaChargingRuleGroup.TAG_NAME, new MetaChargingRuleGroupAction() },
			{ MetaChargingRuleCondition.TAG_NAME, new MetaBaseScriptAction<MetaChargingRuleCondition>() },
			{ MetaChargingRuleExpression.TAG_NAME, new MetaBaseScriptAction<MetaChargingRuleExpression>() },
			{ MetaChargingTargetObject.TAG_NAME, new MetaChargingTargetObjectAction() },
			{ MetaChargingTargetField.TAG_NAME, new MetaChargingTargetFieldAction() }
		};
	}
	
	private static MetaChargingRuleGroupActionMap instance = null;
	public static MetaChargingRuleGroupActionMap getInstance() {
		if ( instance == null ) {
			instance = new MetaChargingRuleGroupActionMap();
		}
		return instance;
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}

}
