package com.bokesoft.yes.meta.persist.dom.charging;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.charging.MetaChargingPara;

public class MetaChargingParaAction extends MetaBaseScriptAction<MetaChargingPara> {

	@Override
	public void load(Document document, Element element, MetaChargingPara meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
	}

	@Override
	public void save(Document document, Element element, MetaChargingPara meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
	}

}
