package com.bokesoft.yes.meta.persist.dom.bpm.action.node;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.node.MetaUserTask;

public class MetaUserTaskAction<T extends MetaUserTask> extends MetaNodeAction<T> {

	@Override
	public void load(Document doc, Element node, T meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setAutoIgnoreNoParticipator(DomHelper.readAttr(node, BPMConstants.NODE_AUTO_IGNORE, false));
		meta.setAutoCommitSameParticipator(DomHelper.readAttr(node, BPMConstants.NODE_AUTO_COMMIT, false));
		meta.setAutoCommitContainSameParticipator(DomHelper.readAttr(node, BPMConstants.NODE_AUTO_COMMIT_CONTAIN, false));
		meta.setCreateTrigger(DomHelper.readAttr(node, BPMConstants.NODE_CREATE_TRIGGER, ""));
		meta.setFinishTrigger(DomHelper.readAttr(node, BPMConstants.NODE_FINISH_TRIGGER, ""));
		meta.setFormKey(DomHelper.readAttr(node, BPMConstants.FORM_KEY, ""));
		meta.setStatus(DomHelper.readAttr(node, BPMConstants.NODE_STATUS, ""));
	}

	@Override
	public void save(Document doc, Element node, T meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.NODE_AUTO_IGNORE, meta.isAutoIgnoreNoParticipator(), false);
		DomHelper.writeAttr(node, BPMConstants.NODE_AUTO_COMMIT, meta.isAutoCommitSameParticipator(), false);
		DomHelper.writeAttr(node, BPMConstants.NODE_AUTO_COMMIT_CONTAIN, meta.isAutoCommitContainSameParticipator(), false);
		DomHelper.writeAttr(node, BPMConstants.NODE_CREATE_TRIGGER, meta.getCreateTrigger(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_FINISH_TRIGGER, meta.getFinishTrigger(), "");
		DomHelper.writeAttr(node, BPMConstants.FORM_KEY, meta.getFormKey(), "");
		DomHelper.writeAttr(node, BPMConstants.NODE_STATUS, meta.getStatus(), "");
	}

}
