package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.bpm.action.MetaBPMElementAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;

public class MetaSequenceFlowAction<T extends MetaSequenceFlow> extends MetaBPMElementAction<T> {

	@Override
	public void load(Document doc, Element node, T meta, int runType) {
		super.load(doc, node, meta, runType);
		meta.setTargetNodeKey(DomHelper.readAttr(node, BPMConstants.TRANSITION_TARGETNODEKEY, ""));
		meta.setCondition(DomHelper.readAttr(node, BPMConstants.ELEMENT_CONDITION, "true"));
		meta.setState(DomHelper.readAttr(node, BPMConstants.ELEMENT_STATE, ""));
		meta.setTrigger(DomHelper.readAttr(node, BPMConstants.ELEMENT_TRIGGER, ""));
	}

	@Override
	public void save(Document doc, Element node, T meta, int runType) {
		super.save(doc, node, meta, runType);
		DomHelper.writeAttr(node, BPMConstants.TRANSITION_TARGETNODEKEY, meta.getTargetNodeKey(), "");
		DomHelper.writeAttr(node, BPMConstants.ELEMENT_CONDITION, meta.getCondition(), "true");
		DomHelper.writeAttr(node, BPMConstants.ELEMENT_STATE, meta.getState(), "");
		DomHelper.writeAttr(node, BPMConstants.ELEMENT_TRIGGER, meta.getTrigger(), "");
	}

}
