package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMInfo;

public class MetaBPMInfoAction extends BaseDomAction<MetaBPMInfo> {

	@Override
	public void load(Document doc, Element node, MetaBPMInfo meta, int runType) {
		meta.setCaption(DomHelper.readAttr(node, BPMConstants.COMMON_CAPTION, ""));
		meta.setKey(DomHelper.readAttr(node, BPMConstants.COMMON_KEY, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaBPMInfo meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(node, BPMConstants.COMMON_KEY, meta.getKey(), "");
	}

}
