package com.bokesoft.yes.meta.persist.dom.bpm.action.collection;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaNodeGraphic;

public class MetaNodeGraphicAction extends BaseDomAction<MetaNodeGraphic> {

	public void load(Document doc, Element node, MetaNodeGraphic meta, int runType) {
		meta.setX(DomHelper.readAttr(node, BPMConstants.GRAPHIC_X, 0));
		meta.setY(DomHelper.readAttr(node, BPMConstants.GRAPHIC_Y, 0));
		meta.setWidth(DomHelper.readAttr(node, BPMConstants.GRAPHIC_WIDTH, 80));
		meta.setHeight(DomHelper.readAttr(node, BPMConstants.GRAPHIC_HEIGHT, 50));
		
		meta.setImage(DomHelper.readAttr(node, BPMConstants.GRAPHIC_IMAGE, ""));
		meta.setPastImage(DomHelper.readAttr(node, BPMConstants.GRAPHIC_PASTIMAGE, ""));
		meta.setLastImage(DomHelper.readAttr(node, BPMConstants.GRAPHIC_LASTIMAGE, ""));
		meta.setStyle(DomHelper.readAttr(node, BPMConstants.ELEMENT_STYLE, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaNodeGraphic meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.GRAPHIC_X, meta.getX(), 0);
		DomHelper.writeAttr(node, BPMConstants.GRAPHIC_Y, meta.getY(), 0);
		DomHelper.writeAttr(node, BPMConstants.GRAPHIC_WIDTH, meta.getWidth(), 80);
		DomHelper.writeAttr(node, BPMConstants.GRAPHIC_HEIGHT, meta.getHeight(), 50);
		DomHelper.writeAttr(node, BPMConstants.GRAPHIC_IMAGE, meta.getImage(), "");
		DomHelper.writeAttr(node, BPMConstants.GRAPHIC_PASTIMAGE, meta.getPastImage(), "");
		DomHelper.writeAttr(node, BPMConstants.GRAPHIC_LASTIMAGE, meta.getLastImage(), "");
		DomHelper.writeAttr(node, BPMConstants.ELEMENT_STYLE, meta.getStyle(), "");
	}

}
