package com.bokesoft.yes.meta.persist.dom.bpm.action;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMap;
import com.bokesoft.yigo.meta.bpm.total.ProcessMapType;

public class MetaProcessMapAction extends BaseDomAction<MetaProcessMap> {

	@Override
	public void load(Document doc, Element node, MetaProcessMap meta, int runType) {
		meta.setType(ProcessMapType.parse(DomHelper.readAttr(node, BPMConstants.BPM_TYPE, ProcessMapType.STR_Form)));
		meta.setInitDate(DomHelper.readAttr(node, BPMConstants.COMMON_INIT_DATE, ""));
		meta.setKey(DomHelper.readAttr(node, BPMConstants.COMMON_KEY, ""));
		meta.setStartCaption(DomHelper.readAttr(node, BPMConstants.BPM_STARTCAPTION, ""));
		meta.setProcessKey(DomHelper.readAttr(node, BPMConstants.BPM_PROCESS_KEY, ""));
		meta.setStartAction(DomHelper.readAttr(node, BPMConstants.BPM_STARTACTION, ""));
		meta.setDynamicBinding(DomHelper.readAttr(node, BPMConstants.BPM_DYNAMIC_BINDING, false));
		meta.setProcessKeyFormula(DomHelper.readAttr(node, BPMConstants.BPM_PROCESS_KEY_FORMULA, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaProcessMap meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.BPM_TYPE, ProcessMapType.toString(meta.getType()), ProcessMapType.STR_Form);
		DomHelper.writeAttr(node, BPMConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(node, BPMConstants.BPM_STARTCAPTION, meta.getStartCaption(), "");
		DomHelper.writeAttr(node, BPMConstants.COMMON_INIT_DATE, meta.getInitDate(), "");
		DomHelper.writeAttr(node, BPMConstants.BPM_PROCESS_KEY, meta.getProcessKey(), "");
		DomHelper.writeAttr(node, BPMConstants.BPM_STARTACTION, meta.getStartAction(), "");
		DomHelper.writeAttr(node, BPMConstants.BPM_DYNAMIC_BINDING, meta.isDynamicBinding(), false);
		DomHelper.writeAttr(node, BPMConstants.BPM_PROCESS_KEY_FORMULA, meta.getProcessKeyFormula(), "");
	}
}
