package com.bokesoft.yes.meta.persist.dom.biz;

import org.json.JSONObject;

import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.charging.MetaChargingObjectProfile;
import com.bokesoft.yes.meta.persist.dom.charging.MetaChargingRuleGroupProfile;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.biz.MetaBizExtend;
import com.bokesoft.yigo.meta.charging.MetaChargingObject;
import com.bokesoft.yigo.meta.charging.MetaChargingRuleGroup;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaBizExtendScanLoad extends BaseMetaScanLoad {
	private MetaBizExtend bizExtend = null;
	public MetaBizExtendScanLoad(MetaBizExtend bizExtend, IMetaResolver resolver, MetaProject metaProject, Object context) {
		super(resolver, metaProject, DomMetaConstants.BIZEXTEND_FOLD, context);
		this.bizExtend = bizExtend;
	}

	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		
		JSONObject profileInfo = resolver.readProfile(filePath, 0);
		if (profileInfo != null) {
			String tagName = profileInfo.getString(MetaConstants.COMMON_TAG_NAME);
			if ( MetaChargingObject.TAG_NAME.equals(tagName) ) {
				MetaChargingObjectProfile profile = new MetaChargingObjectProfile();
				profile.setProject(metaProject);
				profile.setResource(filePath);
				
				profile.setKey(profileInfo.optString(MetaConstants.COMMON_KEY));
				profile.setCaption(profileInfo.optString(MetaConstants.COMMON_CAPTION));
				bizExtend.getCharginbObjectList().add(profile);
			} else if ( MetaChargingRuleGroup.TAG_NAME.equals(tagName) ) {
				MetaChargingRuleGroupProfile profile = new MetaChargingRuleGroupProfile();
				profile.setProject(metaProject);
				profile.setResource(filePath);
				
				profile.setKey(profileInfo.optString(MetaConstants.COMMON_KEY));
				profile.setCaption(profileInfo.optString(MetaConstants.COMMON_CAPTION));
				bizExtend.getChargingRuleGroupList().add(profile);
			}
		}
	}
}
