/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.bpm;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractBPMElementJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaNodeAttachment;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaNodeGraphic;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaPreCondition;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataSpecification;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaAssociation;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaDefaultSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaExceptionFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransitionCollection;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class MetaNodeJSONHandler<T extends MetaNode>
extends AbstractBPMElementJSONHandler<T> {
    @Override
    public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
        JSONObject o;
        super.fromJSONImpl(meta, json);
        meta.setCaption(json.optString("caption"));
        meta.setBPMKey(json.optString("processKey"));
        meta.setInUse(Boolean.valueOf(json.optBoolean("inUse")));
        meta.setTag(json.optString("tag"));
        meta.setUserData(json.optString("userData"));
        meta.setWorkitemRevoke(Boolean.valueOf(json.optBoolean("workitemRevoke")));
        meta.setRevokeCondition(json.optString("revokeCondition"));
        meta.setRetreatCaption(json.optString("retreatCaption"));
        meta.setTemplateKey(json.optString("templateKey"));
        meta.setBPMState(Integer.valueOf(json.optInt("bpmState")));
        meta.setRevokeTrigger(json.optString("revokeTrigger"));
        meta.setRefDocKey(json.optString("refDocKey"));
        meta.setRefType(Integer.valueOf(json.optInt("refType")));
        meta.setPattern(json.optString("pattern"));
        meta.setStop(Boolean.valueOf(json.optBoolean("stop")));
        meta.setSync(Boolean.valueOf(json.optBoolean("isSync")));
        meta.setLockWorkitem(Integer.valueOf(json.optInt("lockWorkitem")));
        meta.setExcluded(Boolean.valueOf(json.optBoolean("excluded")));
        JSONArray array = json.optJSONArray("transitionCollection");
        if (array != null) {
            MetaTransitionCollection transitionCollection = new MetaTransitionCollection();
            int size = array.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String tagName = jsonObject.optString("tagName");
                if ("SequenceFlow".equalsIgnoreCase(tagName)) {
                    transitionCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaSequenceFlow.class, jsonObject));
                    continue;
                }
                if ("ExceptionFlow".equalsIgnoreCase(tagName)) {
                    transitionCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaExceptionFlow.class, jsonObject));
                    continue;
                }
                if ("Association".equalsIgnoreCase(tagName)) {
                    transitionCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaAssociation.class, jsonObject));
                    continue;
                }
                if (!"DefaultSequenceFlow".equalsIgnoreCase(tagName)) continue;
                transitionCollection.add((AbstractMetaObject)BPMJSONHandlerUtil.unbuild(MetaDefaultSequenceFlow.class, jsonObject));
            }
            meta.setTransitionCollection(transitionCollection);
        }
        if ((o = json.optJSONObject("dataSpecification")) != null) {
            MetaDataSpecification dataSpecification = BPMJSONHandlerUtil.unbuild(MetaDataSpecification.class, o);
            meta.setDataSpecification(dataSpecification);
        }
        if ((o = json.optJSONObject("nodeGraphic")) != null) {
            MetaNodeGraphic graphic = BPMJSONHandlerUtil.unbuild(MetaNodeGraphic.class, o);
            meta.setNodeGraphic(graphic);
        }
        if ((o = json.optJSONObject("nodeAttachment")) != null) {
            MetaNodeAttachment nodeAttachment = BPMJSONHandlerUtil.unbuild(MetaNodeAttachment.class, o);
            meta.setNodeAttachment(nodeAttachment);
        }
        if ((o = json.optJSONObject("preCondition")) != null) {
            MetaPreCondition preCondition = BPMJSONHandlerUtil.unbuild(MetaPreCondition.class, o);
            meta.setPreCondition(preCondition);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, T meta, BPMSerializeContext hook) throws Throwable {
        MetaPreCondition preCondition;
        MetaNodeAttachment nodeAttachment;
        MetaNodeGraphic graphic;
        MetaDataSpecification dataSpecification;
        super.toJSONImpl(json, meta, hook);
        String caption = hook.getProcessString("BPM_Node", meta.getKey(), meta.getCaption());
        JSONHelper.writeToJSON((JSONObject)json, (String)"caption", (Object)caption);
        JSONHelper.writeToJSON((JSONObject)json, (String)"processKey", (Object)meta.getBPMKey());
        JSONHelper.writeToJSON((JSONObject)json, (String)"inUse", (Object)meta.isInUse());
        JSONHelper.writeToJSON((JSONObject)json, (String)"tag", (Object)meta.getTag());
        JSONHelper.writeToJSON((JSONObject)json, (String)"userData", (Object)meta.getUserData());
        JSONHelper.writeToJSON((JSONObject)json, (String)"workitemRevoke", (Object)meta.isWorkitemRevoke());
        JSONHelper.writeToJSON((JSONObject)json, (String)"revokeCondition", (Object)meta.getRevokeCondition());
        JSONHelper.writeToJSON((JSONObject)json, (String)"retreatCaption", (Object)meta.getRetreatCaption());
        JSONHelper.writeToJSON((JSONObject)json, (String)"templateKey", (Object)meta.getTemplateKey());
        JSONHelper.writeToJSON((JSONObject)json, (String)"bpmState", (Object)meta.getBPMState());
        JSONHelper.writeToJSON((JSONObject)json, (String)"revokeTrigger", (Object)meta.getRevokeTrigger());
        JSONHelper.writeToJSON((JSONObject)json, (String)"refDocKey", (Object)meta.getRefDocKey());
        JSONHelper.writeToJSON((JSONObject)json, (String)"refType", (Object)meta.getRefType());
        JSONHelper.writeToJSON((JSONObject)json, (String)"pattern", (Object)meta.getPattern());
        JSONHelper.writeToJSON((JSONObject)json, (String)"stop", (Object)meta.getStop());
        JSONHelper.writeToJSON((JSONObject)json, (String)"isSync", (Object)meta.isSync());
        JSONHelper.writeToJSON((JSONObject)json, (String)"lockWorkitem", (Object)meta.getLockWorkitem());
        JSONHelper.writeToJSON((JSONObject)json, (String)"excluded", (Object)meta.isExcluded());
        MetaTransitionCollection transitionCollection = meta.getTransitionCollection();
        if (transitionCollection != null) {
            JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, (GenericNoKeyCollection<? extends AbstractMetaObject>)transitionCollection);
            JSONHelper.writeToJSON((JSONObject)json, (String)"transitionCollection", (Object)array);
        }
        if ((dataSpecification = meta.getDataSpecification()) != null) {
            JSONObject o = BPMJSONHandlerUtil.build((AbstractMetaObject)dataSpecification, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"dataSpecification", (Object)o);
        }
        if ((graphic = meta.getNodeGraphic()) != null) {
            JSONObject o = BPMJSONHandlerUtil.build((AbstractMetaObject)graphic, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"nodeGraphic", (Object)o);
        }
        if ((nodeAttachment = meta.getNodeAttachment()) != null) {
            JSONObject o = BPMJSONHandlerUtil.build((AbstractMetaObject)nodeAttachment, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"nodeAttachment", (Object)o);
        }
        if ((preCondition = meta.getPreCondition()) != null) {
            JSONObject o = BPMJSONHandlerUtil.build((AbstractMetaObject)preCondition, hook);
            JSONHelper.writeToJSON((JSONObject)json, (String)"preCondition", (Object)o);
        }
    }
}

