/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.json.bpm;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.bpm.MetaNodeJSONHandler;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItem;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItemCollection;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataOutput;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetaDataOutputJSONHandler
extends MetaNodeJSONHandler<MetaDataOutput> {
    @Override
    public void fromJSONImpl(MetaDataOutput meta, JSONObject json) throws Throwable {
        JSONArray array;
        super.fromJSONImpl(meta, json);
        String s = json.optString("action");
        if (s.length() > 0) {
            MetaBaseScript action = new MetaBaseScript("Action");
            action.setContent(s);
            meta.setAction(action);
        }
        if ((array = json.optJSONArray("dataItemCollection")) != null) {
            MetaDataItemCollection dataItemCollection = new MetaDataItemCollection();
            dataItemCollection.addAll(BPMJSONHandlerUtil.unbuild(MetaDataItem.class, array));
            meta.setDataItemCollection(dataItemCollection);
        }
    }

    @Override
    public void toJSONImpl(JSONObject json, MetaDataOutput meta, BPMSerializeContext hook) throws Throwable {
        MetaDataItemCollection dataItemCollection;
        super.toJSONImpl(json, meta, hook);
        MetaBaseScript action = meta.getAction();
        if (action != null) {
            JSONHelper.writeToJSON((JSONObject)json, (String)"action", (Object)action.getContent().trim());
        }
        if ((dataItemCollection = meta.getDataItemCollection()) != null) {
            JSONArray array = BPMJSONHandlerUtil.buildKeyCollection(hook, (GenericKeyCollection<? extends AbstractMetaObject>)dataItemCollection);
            JSONHelper.writeToJSON((JSONObject)json, (String)"dataItemCollection", (Object)array);
        }
    }

    @Override
    public MetaDataOutput newInstance() {
        return new MetaDataOutput();
    }
}

