package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.report.MetaReportListItem;

public class MetaReportListItemJSONHandler extends AbstractJSONHandler<MetaReportListItem,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportListItem meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VALUE, meta.getValue());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TEXT, meta.getText());
	}

	@Override
	public MetaReportListItem newInstance() {
		return new MetaReportListItem();
	}

	@Override
	public void fromJSONImpl(MetaReportListItem meta, JSONObject json) throws Throwable {
		meta.setValue(json.optString(JSONConstants.COMMON_VALUE));
		meta.setText(json.optString(JSONConstants.COMMON_TEXT));
	}

}
