package com.bokesoft.yes.meta.json.report;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.ReportJSONHandlerUtil;
import com.bokesoft.yigo.meta.report.MetaReport;
import com.bokesoft.yigo.meta.report.MetaReportDataSource;
import com.bokesoft.yigo.meta.report.MetaReportDataTable;
import com.bokesoft.yigo.meta.report.MetaReportGrid;
import com.bokesoft.yigo.meta.report.MetaReportGridSection;
import com.bokesoft.yigo.meta.report.MetaReportWaterprint;
import com.bokesoft.yigo.meta.report.embed.MetaReportEmbed;

public class MetaReportJSONHandler extends AbstractJSONHandler<MetaReport,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReport meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMKEY, meta.getFormKey());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_GROUP, meta.getGroup());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_ISDEFAULT, meta.isDefault());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_ISVIRTUALPAGE, meta.isVirtualPage());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_PAGEID, meta.getPageID());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_PAGEWIDTH, meta.getPageWidth());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_PAGEHEIGHT, meta.getPageHeight());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_PAPERID, meta.getPaperID());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_PAPERWIDTH, meta.getPaperWidth());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_PAPERHEIGHT, meta.getPaperHeight());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_LEFTMARGIN, meta.getLeftMargin());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TOPMARGIN, meta.getTopMargin());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_RIGHTMARGIN, meta.getRightMargin());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BOTTOMMARGIN, meta.getBottomMargin());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_PAPERORIENTATION, meta.getPaperOrientation());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_PAGEORIENTATION, meta.getPageOrientation());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_PRINTORDERTYPE, meta.getPrintOrderType());
		
		MetaReportDataSource reportDataSource = meta.getDataSource();
		if( reportDataSource != null ) {
			JSONArray array = ReportJSONHandlerUtil.buildKeyWithKeyCollection(hook, reportDataSource);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_DATASOURCE, array);
		}
		
		MetaReportGrid reportGrid = meta.getGrid();
		if( reportGrid != null ) {
			JSONArray array = ReportJSONHandlerUtil.buildNoKeyCollection(hook, reportGrid);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_GRID, array);
		}
		
		MetaReportEmbed reportEmbed = meta.getEmbed();
		if( reportEmbed != null ) {
			JSONObject object = ReportJSONHandlerUtil.build(reportEmbed, hook);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_EMBED, object);
		}
		
		MetaReportWaterprint reportWaterprint = meta.getWaterprint();
		if( reportWaterprint != null ) {
			JSONObject object = ReportJSONHandlerUtil.build(reportWaterprint, hook);
			JSONHelper.writeToJSON(json, JSONConstants.REPORT_WATERPRINT, object);
		}
	}

	@Override
	public MetaReport newInstance() {
		return new MetaReport();
	}

	@Override
	public void fromJSONImpl(MetaReport meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setFormKey(json.optString(JSONConstants.COMMON_FORMKEY));
		meta.setGroup(json.optString(JSONConstants.REPORT_GROUPKEY));
		meta.setDefault(json.optBoolean(JSONConstants.REPORT_ISDEFAULT));
		meta.setVirtualPage(json.optBoolean(JSONConstants.REPORT_ISVIRTUALPAGE));
		meta.setPageID(json.optString(JSONConstants.REPORT_PAGEID));
		meta.setPageWidth(json.optInt(JSONConstants.REPORT_PAGEWIDTH));
		meta.setPageHeight(json.optInt(JSONConstants.REPORT_PAGEHEIGHT));
		meta.setPaperID(json.optString(JSONConstants.REPORT_PAPERID));
		meta.setPaperWidth(json.optInt(JSONConstants.REPORT_PAPERWIDTH));
		meta.setPaperHeight(json.optInt(JSONConstants.REPORT_PAPERHEIGHT));
		meta.setLeftMargin(json.optInt(JSONConstants.COMMON_LEFTMARGIN));
		meta.setTopMargin(json.optInt(JSONConstants.COMMON_TOPMARGIN));
		meta.setRightMargin(json.optInt(JSONConstants.COMMON_RIGHTMARGIN));
		meta.setBottomMargin(json.optInt(JSONConstants.COMMON_BOTTOMMARGIN));
		meta.setPaperOrientation(json.optInt(JSONConstants.REPORT_PAPERORIENTATION));
		meta.setPageOrientation(json.optInt(JSONConstants.REPORT_PAGEORIENTATION));
		meta.setPrintOrderType(json.optInt(JSONConstants.REPORT_PRINTORDERTYPE));
		
		JSONArray array = json.optJSONArray(JSONConstants.REPORT_DATASOURCE);
		if( array != null ) {
			List<MetaReportDataTable> list = ReportJSONHandlerUtil.unbuild(MetaReportDataTable.class, array);
			MetaReportDataSource reportDataSource = new MetaReportDataSource();
			reportDataSource.addAll(list);
			meta.setDataSource(reportDataSource);
		}
		
		array = json.optJSONArray(JSONConstants.REPORT_GRID);
		if( array != null ) {
			List<MetaReportGridSection> list = ReportJSONHandlerUtil.unbuild(MetaReportGridSection.class, array);
			MetaReportGrid reportGrid = new MetaReportGrid();
			reportGrid.addAll(0, list);
			meta.setGrid(reportGrid);
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.REPORT_EMBED);
		if( o != null ) {
			MetaReportEmbed embed = ReportJSONHandlerUtil.unbuild(MetaReportEmbed.class, json);
			meta.setEmbed(embed);
		}
		
		o = json.optJSONObject(JSONConstants.REPORT_WATERPRINT);
		if( o != null ) {
			MetaReportWaterprint reportWaterprint = ReportJSONHandlerUtil.unbuild(MetaReportWaterprint.class, o);
			meta.setWaterprint(reportWaterprint);
		}
	}

}
