package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.report.MetaReportImageStyle;

public class MetaReportImageStyleJSONHandler extends AbstractJSONHandler<MetaReportImageStyle,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportImageStyle meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_IMAGESCALETYPE, meta.getImageScaleType());
	}

	@Override
	public MetaReportImageStyle newInstance() {
		return new MetaReportImageStyle();
	}

	@Override
	public void fromJSONImpl(MetaReportImageStyle meta, JSONObject json) throws Throwable {
		meta.setImageScaleType(json.optInt(JSONConstants.REPORT_IMAGESCALETYPE));
	}

}
