package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.report.MetaReportDataField;

public class MetaReportDataFieldJSONHandler extends AbstractJSONHandler<MetaReportDataField,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportDataField meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DESCRIPTION, meta.getDescription());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_DBFIELDKEY, meta.getDBFieldKey());
	}

	@Override
	public MetaReportDataField newInstance() {
		return new MetaReportDataField();
	}

	@Override
	public void fromJSONImpl(MetaReportDataField meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setDescription(json.optString(JSONConstants.COMMON_DESCRIPTION));
		meta.setDBFieldKey(json.optString(JSONConstants.REPORT_DBFIELDKEY));
	}

}
