package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaBaseScriptJSONHandler;
import com.bokesoft.yigo.meta.report.MetaReportColumnExpand;

public class MetaReportColumnExpandJSONHandler extends MetaBaseScriptJSONHandler<MetaReportColumnExpand,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportColumnExpand meta, SolutionSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_EXPANDTYPE, meta.getExpandType());
		JSONHelper.writeToJSON(json, JSONConstants.REPORT_SOURCETYPE, meta.getSourceType());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_COLUMNKEY, meta.getColumnKey());
	}
	
	@Override
	public void fromJSONImpl(MetaReportColumnExpand meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setExpandType(json.optInt(JSONConstants.REPORT_EXPANDTYPE));
		meta.setSourceType(json.optInt(JSONConstants.REPORT_SOURCETYPE));
		meta.setColumnKey(json.optString(JSONConstants.COMMON_COLUMNKEY));
	}
	
	@Override
	public MetaReportColumnExpand newInstance() {
		return new MetaReportColumnExpand();
	}
}
