package com.bokesoft.yes.meta.json.report;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.ReportJSONHandlerUtil;
import com.bokesoft.yigo.common.def.EChartRenderType;
import com.bokesoft.yigo.meta.report.embed.MetaReportChart;
import com.bokesoft.yigo.meta.report.embed.chart.MetaReportChartDataSource;

public class MetaReportChartJSONHandler extends AbstractJSONHandler<MetaReportChart,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaReportChart meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_X, meta.getX());
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_Y, meta.getY());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, meta.getWidth());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_HEIGHT, meta.getHeight());
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		
		JSONHelper.writeToJSON(json, JSONConstants.CHART_CHARTTYPE, meta.getChartType());
		JSONHelper.writeToJSON(json, JSONConstants.CHART_TITLE, meta.getTitle());
		JSONHelper.writeToJSON(json, JSONConstants.CHART_SERICESINROW, meta.getSeriesInRow());
		JSONHelper.writeToJSON(json, JSONConstants.CHART_SERICESAXISTITLE, meta.getSeriesAxisTitle());
		JSONHelper.writeToJSON(json, JSONConstants.CHART_CATEGORYAXISTITLE, meta.getCategoryAxisTitle());
		JSONHelper.writeToJSON(json, JSONConstants.CHART_SHOWVALUES, meta.isShowValue());
		JSONHelper.writeToJSON(json, JSONConstants.CHART_FILL, meta.isFill());
		JSONHelper.writeToJSON(json, JSONConstants.CHART_RENDERTYPE, meta.getRenderType().toString());
		
		MetaReportChartDataSource dataSource = meta.getDataSource();
		if( dataSource != null ) {
			JSONObject o = ReportJSONHandlerUtil.build(dataSource, hook);
			JSONHelper.writeToJSON(json, JSONConstants.CHART_DATASOURCE, o);
		}

	}

	@Override
	public MetaReportChart newInstance() {
		return new MetaReportChart();
	}

	@Override
	public void fromJSONImpl(MetaReportChart meta, JSONObject json) throws Throwable {
		meta.setX(json.optInt(JSONConstants.COMPONENT_X));
		meta.setY(json.optInt(JSONConstants.COMPONENT_Y));
		meta.setWidth(json.optInt(JSONConstants.COMMON_WIDTH));
		meta.setHeight(json.optInt(JSONConstants.COMMON_HEIGHT));
	
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		
		meta.setChartType(json.optInt(JSONConstants.CHART_CHARTTYPE));
		meta.setTitle(json.optString(JSONConstants.CHART_TITLE));
		meta.setSeriesInRow(json.optBoolean(JSONConstants.CHART_SERICESINROW));
		meta.setSeriesAxisTitle(json.optString(JSONConstants.CHART_SERICESAXISTITLE));
		meta.setCategoryAxisTitle(json.optString(JSONConstants.CHART_CATEGORYAXISTITLE));
		meta.setShowValue(json.optBoolean(JSONConstants.CHART_SHOWVALUES));
		meta.setFill(json.optBoolean(JSONConstants.CHART_FILL));
		
		String renderType = json.optString(JSONConstants.CHART_RENDERTYPE);
		if( "Draw".equals(renderType) ) {
			meta.setRenderType(EChartRenderType.Draw);
		}
		if( "Image".equals(renderType) ) {
			meta.setRenderType(EChartRenderType.Image);
		}
		if( "SVG".equals(renderType) ) {
			meta.setRenderType(EChartRenderType.SVG);
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.CHART_DATASOURCE);
		if( o != null ) {
			MetaReportChartDataSource dataSource = ReportJSONHandlerUtil.unbuild(MetaReportChartDataSource.class, o);
			meta.setDataSource(dataSource);
		}
	}

}
