package com.bokesoft.yes.meta.json.panel;

import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitPanel;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitSize;
import com.bokesoft.yigo.meta.form.component.panel.MetaSplitSizeCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSplitItem;

public class MetaSplitPanelJSONHandler extends BasePanelJSONHandler<MetaSplitPanel> {

	@Override
	public void fromJSONImpl(MetaSplitPanel meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setOrientation(json.optInt(JSONConstants.SPLITPANEL_ORIENTATION));

		JSONObject layoutObject = json.optJSONObject(JSONConstants.BASEPANEL_LAYOUT);
		JSONArray sizeArray = layoutObject.optJSONArray(JSONConstants.COMMON_ITEMS);
		ArrayList<MetaLayoutSplitItem> items = 
				(ArrayList<MetaLayoutSplitItem>) UIJSONHandlerUtil.unbuild(MetaLayoutSplitItem.class, sizeArray);

		MetaSplitSizeCollection sizeCollection = new MetaSplitSizeCollection();
		for (int i = 0; i < items.size(); i++) {
			MetaSplitSize size = new MetaSplitSize();
			size.setSize(items.get(i).getSize());
			size.setType(items.get(i).getType());
			size.setForwardCollapased(items.get(i).getForwardCollapased());
			size.setReverseCollapased(items.get(i).getReverseCollapased());
			sizeCollection.add(size);
		}
		meta.setSplitSize(sizeCollection);
	}

	@Override
	public void toJSONImpl(JSONObject json, MetaSplitPanel meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.SPLITPANEL_ORIENTATION, meta.getOrientation());
	}

	@Override
	public MetaSplitPanel newInstance() {
		return new MetaSplitPanel();
	}
}
