package com.bokesoft.yes.meta.json.other;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yigo.meta.common.MetaStatement;

public class MetaStatementJSONHandler extends AbstractJSONHandler<MetaStatement,ISerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaStatement meta, ISerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.STATEMENT_CONTENT, meta.getContent());
		JSONHelper.writeToJSON(json, JSONConstants.STATEMENT_DBTYPE, meta.getDBType());
		JSONHelper.writeToJSON(json, JSONConstants.STATEMENT_DYNAMIC, meta.isDynamic());
	}

	@Override
	public MetaStatement newInstance() {
		return new MetaStatement();
	}

	@Override
	public void fromJSONImpl(MetaStatement meta, JSONObject json) throws Throwable {
		meta.setContent(json.optString(JSONConstants.STATEMENT_CONTENT));
		meta.setDBType(json.optString(JSONConstants.STATEMENT_DBTYPE));
		meta.setDynamic(json.optBoolean(JSONConstants.STATEMENT_DYNAMIC));
	}

}
