package com.bokesoft.yes.meta.json.other;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.solution.MetaLang;

public class MetaLangJSONHandler extends AbstractJSONHandler<MetaLang,SolutionSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaLang meta, SolutionSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DESCRIPTION, meta.getDescription());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_SUFFIX, meta.getSuffix());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BASE_LANG, meta.getBaseLang());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ENABLE_TRANSLATE, meta.isEnableTranslate());
	}

	@Override
	public MetaLang newInstance() {
		return new MetaLang();
	}

	@Override
	public void fromJSONImpl(MetaLang meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setDescription(json.optString(JSONConstants.COMMON_DESCRIPTION));
		meta.setSuffix(json.optString(JSONConstants.COMMON_SUFFIX));
		meta.setBaseLang(json.optString(JSONConstants.COMMON_BASE_LANG));
		meta.setEnableTranslate(json.optBoolean(JSONConstants.COMMON_ENABLE_TRANSLATE));
	}

}
