package com.bokesoft.yes.meta.json.mobiledef;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yigo.meta.mobiledef.MetaVibratorItem;

public class MetaVibratorItemJSONHandler extends AbstractJSONHandler<MetaVibratorItem,SolutionSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaVibratorItem meta, SolutionSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_MILLISECONDS, meta.getMilliseconds());
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_PATTERN, meta.getPattern());
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_REPEAT, meta.getRepeat());
		JSONHelper.writeToJSON(json, JSONConstants.MOBILEDEF_DELAYTIME, meta.getDelayTime());
	}

	@Override
	public void fromJSONImpl(MetaVibratorItem meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setMilliseconds(json.optInt(JSONConstants.MOBILEDEF_MILLISECONDS));
		meta.setPattern(json.optString(JSONConstants.MOBILEDEF_PATTERN));
		meta.setRepeat(json.optInt(JSONConstants.MOBILEDEF_REPEAT));
		meta.setDelayTime(json.optInt(JSONConstants.MOBILEDEF_DELAYTIME));
	}

	@Override
	public MetaVibratorItem newInstance() {
		return new MetaVibratorItem();
	}

}
