package com.bokesoft.yes.meta.json.layout;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaComponentLayoutJSONHandler;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutColumn;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutColumnCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutRow;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutRowCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTableLayout;

public class MetaTableLayoutJSONHandler extends MetaComponentLayoutJSONHandler {

	@Override
	public void toJSONImpl(JSONObject json,MetaComponentLayout<? extends MetaLayoutItem> meta, 
			DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);

		MetaTableLayout layout = (MetaTableLayout) meta;

		MetaLayoutColumnCollection columnCollection = layout.getColumnCollection();
		if (columnCollection != null) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, columnCollection);
			JSONHelper.writeToJSON(json, JSONConstants.LAYOUT_ROWCOLLECTION, array);
		}
		MetaLayoutRowCollection rowCollection = layout.getRowCollection();
		if (rowCollection != null) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, rowCollection);
			JSONHelper.writeToJSON(json, JSONConstants.LAYOUT_COLUMNCOLLECTION, array);
		}
	}
	
	@Override
	public void fromJSONImpl(MetaComponentLayout<? extends MetaLayoutItem> meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		MetaTableLayout layout = (MetaTableLayout) meta;
		
		JSONArray array = json.getJSONArray(JSONConstants.LAYOUT_ROWCOLLECTION);
		if( array != null ) {
			MetaLayoutColumnCollection columnCollection = new MetaLayoutColumnCollection();
			List<MetaLayoutColumn> list = UIJSONHandlerUtil.unbuild(MetaLayoutColumn.class, array);
			columnCollection.addAll(0, list);
			layout.setColumnCollection(columnCollection);
		}
		
		array = json.optJSONArray(JSONConstants.LAYOUT_COLUMNCOLLECTION);
		if( array != null ) {
			MetaLayoutRowCollection rowCollection = new MetaLayoutRowCollection();
			List<MetaLayoutRow> list = UIJSONHandlerUtil.unbuild(MetaLayoutRow.class, array);
			rowCollection.addAll(0, list);
			layout.setRowCollection(rowCollection);
		}
	}

	@Override
	public MetaComponentLayout<? extends MetaLayoutItem> newInstance() {
		return new MetaTableLayout();
	}

}
