package com.bokesoft.yes.meta.json.layout;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaComponentLayoutJSONHandler;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaCustomLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutItem;

public class MetaCustomLayoutJSONHandler extends MetaComponentLayoutJSONHandler {
	
	@Override
	public void toJSONImpl(JSONObject json,MetaComponentLayout<? extends MetaLayoutItem> meta, 
			DefaultSerializeContext hook) throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		MetaCustomLayout layout = (MetaCustomLayout)meta;
		
		MetaRowDefCollection rowDefCollection = layout.getRowDefCollection();
		if( rowDefCollection != null ) {
			JSONObject o = UIJSONHandlerUtil.build(rowDefCollection,hook);
			JSONHelper.writeToJSON(json, JSONConstants.LAYOUTPANEL_ROWS, o);
		}

		MetaColumnDefCollection columnDefCollection = layout.getColumnDefCollection();
		if( columnDefCollection != null ) {
			JSONObject o = UIJSONHandlerUtil.build(columnDefCollection,hook);			
			JSONHelper.writeToJSON(json, JSONConstants.LAYOUTPANEL_COLUMNS, o);
		}
	}
	
	@Override
	public void fromJSONImpl(MetaComponentLayout<? extends MetaLayoutItem> meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		MetaCustomLayout layout = (MetaCustomLayout)meta;
		
		JSONObject o = json.optJSONObject(JSONConstants.LAYOUTPANEL_ROWS);
		if( o != null ) {
			MetaRowDefCollection rowDefCollection = UIJSONHandlerUtil.unbuild(MetaRowDefCollection.class, o);
			layout.setRowDefCollection(rowDefCollection);
		}
		
		o = json.optJSONObject(JSONConstants.LAYOUTPANEL_COLUMNS);
		if( o != null ) {
			MetaColumnDefCollection columnDefCollection = UIJSONHandlerUtil.unbuild(MetaColumnDefCollection.class, o);
			layout.setColumnDefCollection(columnDefCollection);
		}
	}

	@Override
	public MetaComponentLayout<? extends MetaLayoutItem> newInstance() {
		return new MetaCustomLayout();
	}

}
