package com.bokesoft.yes.meta.json.form;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.view.MetaComponentView;
import com.bokesoft.yigo.meta.form.component.view.MetaView;

public class MetaViewJSONHandler extends AbstractJSONHandler<MetaView,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaView meta, DefaultSerializeContext hook)
			throws Throwable {
		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.VIEW_MEDIA, meta.getMedia());
		JSONHelper.writeToJSON(json, JSONConstants.VIEW_RULE, meta.getRule());
		JSONHelper.writeToJSON(json, JSONConstants.VIEW_SIZE, meta.getSize());
		
		JSONArray array = UIJSONHandlerUtil.buildKeyWithKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
	}

	@Override
	public void fromJSONImpl(MetaView meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setMedia(json.optInt(JSONConstants.VIEW_MEDIA));
		meta.setRule(json.optString(JSONConstants.VIEW_RULE));
		meta.setSize(json.optString(JSONConstants.VIEW_SIZE));
		
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if( array != null ) {
			List<MetaComponentView> list = UIJSONHandlerUtil.unbuild(MetaComponentView.class, array);
			meta.addAll(list);
		}
	}
	
	@Override
	public MetaView newInstance() {
		return new MetaView();
	}

}
