package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.MetaUICalcExpr;

public class MetaUICalcExprJSONHandler extends AbstractJSONHandler<MetaUICalcExpr,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaUICalcExpr meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DESCRIPTION, meta.getDescription());
		JSONHelper.writeToJSON(json, JSONConstants.DATABINDING_DEFAULTFORMULAVALUE, meta.getDefaultFormulaValue());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TARGET, meta.getTarget());
	}

	@Override
	public void fromJSONImpl(MetaUICalcExpr meta, JSONObject json) throws Throwable {
		meta.setDescription(json.optString(JSONConstants.COMMON_DESCRIPTION));
		meta.setDefaultFormulaValue(json.optString(JSONConstants.DATABINDING_DEFAULTFORMULAVALUE));
		meta.setTarget(json.optString(JSONConstants.COMMON_TARGET));
	}
	
	@Override
	public MetaUICalcExpr newInstance() {
		return new MetaUICalcExpr();
	}

}
