package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.MetaNavigationBarItem;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

public class MetaNavigationBarItemJSONHandler extends AbstractJSONHandler<MetaNavigationBarItem,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaNavigationBarItem meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONBARITEM_LOCATION, meta.getLocation());
		
		// TODO 这里反序列化后 是新的对象  可能会有问题  后面看 再改
		MetaComponent root = meta.getRoot();
		if( meta.getRoot() != null ){
			JSONObject o = UIJSONHandlerUtil.build(root,hook);
			json.put(JSONConstants.COMMON_ROOT, o);
		}
		
	}

	@Override
	public void fromJSONImpl(MetaNavigationBarItem meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setCaption(json.optString(JSONConstants.COMMON_CAPTION));
		meta.setLocation(json.optInt(JSONConstants.NAVIGATIONBARITEM_LOCATION));
		
		JSONObject o = json.optJSONObject(JSONConstants.COMMON_ROOT);
		if( o != null ) {
			MetaComponent root = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
			meta.setRoot(root);
		}
	}
	
	@Override
	public MetaNavigationBarItem newInstance() {
		return new MetaNavigationBarItem();
	}

}
