package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;

public class MetaDataSourceJSONHandler extends AbstractJSONHandler<MetaDataSource,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaDataSource meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.DATASOURCE_REFOBJECTKEY, meta.getRefObjectKey());
		JSONHelper.writeToJSON(json, JSONConstants.DATASOURCE_REFTABLEKEY, meta.getRefTableKey());
		
		MetaDataObject dataObject = meta.getDataObject();
		if( dataObject != null ) {
			JSONObject o = UIJSONHandlerUtil.build(dataObject,hook);
			JSONHelper.writeToJSON(json, JSONConstants.FORM_DATAOBJECT, o);
		}
	}
	
	@Override
	public void fromJSONImpl(MetaDataSource meta, JSONObject json) throws Throwable {
		meta.setRefObjectKey(json.optString(JSONConstants.DATASOURCE_REFOBJECTKEY));
		meta.setRefTableKey(json.optString(JSONConstants.DATASOURCE_REFTABLEKEY));

		JSONObject o = json.optJSONObject(JSONConstants.FORM_DATAOBJECT);
		if( o != null ) {
			MetaDataObject dataObject = UIJSONHandlerUtil.unbuild(MetaDataObject.class, o);
			meta.setDataObject(dataObject);
		}
	}

	@Override
	public MetaDataSource newInstance() {
		return new MetaDataSource();
	} 

}
