package com.bokesoft.yes.meta.json.form;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaBaseScriptJSONHandler<T extends MetaBaseScript,C extends ISerializeContext> extends AbstractJSONHandler<T,C> {

	@Override
	public void toJSONImpl(JSONObject json, T meta, C hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TYPE, meta.getType());
		JSONHelper.writeToJSON(json, JSONConstants.SCRIPT_RUNTYPE, meta.getRunType());
		JSONHelper.writeToJSON(json, JSONConstants.SCRIPT_CONTENT, meta.getContent().trim());
	}
	
	@Override
	public void fromJSONImpl(T meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setType(json.optInt(JSONConstants.COMMON_TYPE));
		meta.setRunType(json.optInt(JSONConstants.SCRIPT_RUNTYPE));
		meta.setContent(json.optString(JSONConstants.SCRIPT_CONTENT));
	}

	@Override
	public T newInstance() {
		// TODO Auto-generated method stub
		return null;
	}

}
