package com.bokesoft.yes.meta.json.com.properties;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaRadioButtonProperties;
import org.json.JSONObject;

public class MetaRadioButtonPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaRadioButtonProperties>{
	
	@Override
	public void toJSONImpl(JSONObject json, MetaRadioButtonProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.RADIOBUTTON_GROUPKEY, meta.getGroupKey());
		JSONHelper.writeToJSON(json, JSONConstants.RADIOBUTTON_METAVALUE, meta.getSelectedValue());
		JSONHelper.writeToJSON(json, JSONConstants.RADIOBUTTON_ISGROUPHEAD, meta.getGroupHead());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_SELECTEDICON, meta.getSelectedIcon());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_ICONLOCATION, meta.getIconLocation());
		JSONHelper.writeToJSON(json, JSONConstants.CHECKBOX_HIDEBUTTON, meta.getHideButton());
	}

	@Override
	public void fromJSONImpl(MetaRadioButtonProperties meta, JSONObject json) throws Throwable {
		meta.setGroupKey(json.optString(JSONConstants.RADIOBUTTON_GROUPKEY));
		meta.setSelectedValue(json.optString(JSONConstants.RADIOBUTTON_METAVALUE));
		meta.setGroupHead(json.optBoolean(JSONConstants.RADIOBUTTON_ISGROUPHEAD));
		meta.setIcon(json.optString(JSONConstants.COMMON_ICON));
		meta.setSelectedIcon(json.optString(JSONConstants.CHECKBOX_SELECTEDICON));
		meta.setIconLocation(json.optInt(JSONConstants.CHECKBOX_ICONLOCATION));
		meta.setHideButton(json.optBoolean(JSONConstants.CHECKBOX_HIDEBUTTON));
	}

	@Override
	public MetaRadioButtonProperties newInstance() {
		return new MetaRadioButtonProperties();
	}

}
