package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yigo.meta.dataobject.MetaParameter;

public class MetaParameterJSONHandler extends AbstractJSONHandler<MetaParameter,ISerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaParameter meta, ISerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.QUERY_PARA_TARGET_TABLE, meta.getTargetTable());
		JSONHelper.writeToJSON(json, JSONConstants.QUERY_PARA_TARGET_COLUMN, meta.getTargetColumn());
		JSONHelper.writeToJSON(json, JSONConstants.QUERY_PARA_SOURCE_TYPE, meta.getSourceType());
		JSONHelper.writeToJSON(json, JSONConstants.QUERY_PARA_FORMULA, meta.getFormula());
		JSONHelper.writeToJSON(json, JSONConstants.QUERY_PARA_FIELDKEY, meta.getFieldKey());
		JSONHelper.writeToJSON(json, JSONConstants.QUERY_PARA_VALUE, meta.getValue());
		JSONHelper.writeToJSON(json, JSONConstants.COLUMN_DATATYPE, meta.getDataType());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DESCRIPTION, meta.getDescription());
	}

	@Override
	public void fromJSONImpl(MetaParameter meta, JSONObject json) throws Throwable {
		meta.setTargetTable(json.optString(JSONConstants.QUERY_PARA_TARGET_TABLE));
		meta.setTargetColumn(json.optString(JSONConstants.QUERY_PARA_TARGET_COLUMN));
		meta.setSourceType(json.optInt(JSONConstants.QUERY_PARA_SOURCE_TYPE));
		meta.setFormula(json.optString(JSONConstants.QUERY_PARA_FORMULA));
		meta.setFieldKey(json.optString(JSONConstants.QUERY_PARA_FIELDKEY));
		meta.setValue(json.optString(JSONConstants.QUERY_PARA_VALUE));
		meta.setDataType(json.optInt(JSONConstants.COLUMN_DATATYPE));
		meta.setDescription(json.optString(JSONConstants.COMMON_DESCRIPTION));
	}

	@Override
	public MetaParameter newInstance() {
		return new MetaParameter();
	}

}
