package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHyperLinkProperties;

public class MetaHyperLinkPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaHyperLinkProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaHyperLinkProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.HYPERLINK_URL, meta.getURL());
		JSONHelper.writeToJSON(json, JSONConstants.HYPERLINK_TARGETSHOWTYPE, meta.getTargetShowType());
		JSONHelper.writeToJSON(json, JSONConstants.HYPERLINK_FORMULAURL, meta.getFormulaURL());
		JSONHelper.writeToJSON(json, JSONConstants.BUTTON_NEEDAUTHENTICATE, meta.isNeedAuthenticate());
		
		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent().trim());
		}
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CHECK_ON_CLICK_NODE, meta.getCheckOnClickNode());
	}

	@Override
	public void fromJSONImpl(MetaHyperLinkProperties meta, JSONObject json) throws Throwable {
		meta.setURL(json.optString(JSONConstants.HYPERLINK_URL));
		meta.setTargetShowType(json.optInt(JSONConstants.HYPERLINK_TARGETSHOWTYPE));
		meta.setFormulaURL(json.optString(JSONConstants.HYPERLINK_FORMULAURL));
		meta.setNeedAuthenticate(json.optBoolean(JSONConstants.BUTTON_NEEDAUTHENTICATE, false));
		
		String s = json.optString(JSONConstants.Event_OnClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
			script.setContent(s);
			meta.setOnClick(script);
		}
		meta.setCheckOnClickNode(json.optBoolean(JSONConstants.COMMON_CHECK_ON_CLICK_NODE));
	}

	@Override
	public MetaHyperLinkProperties newInstance() {
		return new MetaHyperLinkProperties();
	}
	
}

