package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFileChooserProperties;

public class MetaFileChooserPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaFileChooserProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaFileChooserProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.FILECHOOSER_USETYPE, meta.getUseType());
		JSONHelper.writeToJSON(json, JSONConstants.FILECHOOSER_EXTFILTER, meta.getExtFilter());
		JSONHelper.writeToJSON(json, JSONConstants.FILECHOOSER_ALLOWMULTI, meta.isAllowMulti());
	}

	@Override
	public void fromJSONImpl(MetaFileChooserProperties meta, JSONObject json) throws Throwable {
		meta.setUseType(json.optString(JSONConstants.FILECHOOSER_USETYPE));
		meta.setExtFilter(json.optString(JSONConstants.FILECHOOSER_EXTFILTER));
		meta.setAllowMulti(json.optBoolean(JSONConstants.FILECHOOSER_ALLOWMULTI));
		
	}

	@Override
	public MetaFileChooserProperties newInstance() {
		return new MetaFileChooserProperties();
	}
	
	
}

