package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDynamicProperties;

public class MetaDynamicPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaDynamicProperties>{

	@Override
	public void toJSONImpl(JSONObject json, MetaDynamicProperties meta, DefaultSerializeContext hook,
			String key) throws Throwable {
		
		JSONHelper.writeToJSON(json, JSONConstants.TYPE_FORMULA, meta.getTypeFormula());		
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DEPENDENCY, meta.getTypeDependency());
	}

	@Override
	public void fromJSONImpl(MetaDynamicProperties meta, JSONObject json) throws Throwable {
		meta.setTypeFormula(json.optString(JSONConstants.TYPE_FORMULA));
		meta.setTypeDependency(json.optString(JSONConstants.TYPE_DEPENDENCY));
	}

	@Override
	public MetaDynamicProperties newInstance() {
		return new MetaDynamicProperties();
	}

}
