package com.bokesoft.yes.meta.json.com.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCountDownViewProperties;

public class MetaCountDownViewPropertiesJSONHandler extends BasePropertiesJSONHandler<MetaCountDownViewProperties> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaCountDownViewProperties meta,
			DefaultSerializeContext hook, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COUNTDOWNVIEW_STYLE, meta.getStyle());
		JSONHelper.writeToJSON(json, JSONConstants.COUNTDOWNVIEW_STEPPER, meta.getStepper());
		JSONHelper.writeToJSON(json, JSONConstants.COUNTDOWNVIEW_MAXTIME, meta.getMaxTime());
		JSONHelper.writeToJSON(json, JSONConstants.COUNTDOWNVIEW_REPEAT, meta.isRepeat());
		JSONHelper.writeToJSON(json, JSONConstants.COUNTDOWNVIEW_ENDCAPTION, meta.getEndCaption());
		
		MetaBaseScript onClick = meta.getOnClick();
		if( meta.getOnClick() != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COUNTDOWNVIEW_ONCLICK, onClick.getContent().trim());
		}
		
		MetaBaseScript onFinish = meta.getOnFinish();
		if( meta.getOnFinish() != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.COUNTDOWNVIEW_ONFINISH, onFinish.getContent());
		}
	}

	@Override
	public void fromJSONImpl(MetaCountDownViewProperties meta, JSONObject json) throws Throwable {
		meta.setStyle(json.optInt(JSONConstants.COUNTDOWNVIEW_STYLE));
		meta.setStepper(json.optInt(JSONConstants.COUNTDOWNVIEW_STEPPER));
		meta.setMaxTime(json.optInt(JSONConstants.COUNTDOWNVIEW_MAXTIME));
		meta.setRepeat(json.optBoolean(JSONConstants.COUNTDOWNVIEW_REPEAT));
		meta.setEndCaption(json.optString(JSONConstants.COUNTDOWNVIEW_ENDCAPTION));
		
		String s = json.optString(JSONConstants.COUNTDOWNVIEW_ONCLICK);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
			script.setContent(s);
			meta.setOnClick(script);
		}
		
		s = json.optString(JSONConstants.COUNTDOWNVIEW_ONFINISH);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
			script.setContent(s);
			meta.setOnFinish(script);
		}
	}

	@Override
	public MetaCountDownViewProperties newInstance() {
		return new MetaCountDownViewProperties();
	}

}
