package com.bokesoft.yes.meta.json.com.grid;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.grid.IMetaGridRowObject;
import com.bokesoft.yigo.meta.form.component.grid.MetaExtOpt;
import com.bokesoft.yigo.meta.form.component.grid.MetaExtOptCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridFilter;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRowCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRowLayer;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowAreaExpand;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowTree;
import com.bokesoft.yigo.meta.form.component.grid.MetaTrace;
import com.bokesoft.yigo.meta.form.component.grid.MetaTraceCollection;

public class MetaGridJSONHandler extends BaseComponentJSONHandler<MetaGrid> {

	@Override
	public void fromJSONImpl(MetaGrid meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setGridDefaultSortField(json.optString(JSONConstants.GRID_SORT));
		meta.setHasColumnExpand(json.optBoolean(JSONConstants.GRID_HASCOLEXPAND));
		meta.setHasCellExpand(json.optBoolean(JSONConstants.GRID_HASCELLEXPAND));
		meta.setHasRowExpand(json.optBoolean(JSONConstants.GRID_HASROWEXPAND));
		meta.setHasRowGroup(json.optBoolean(JSONConstants.GRID_HASROWGROUP));
		meta.setHasFixRow(json.optBoolean(JSONConstants.GRID_HASFIXROW));
		meta.setHasTotalRow(json.optBoolean(JSONConstants.GRID_HASTOTALROW));
		meta.setHasFixCellMerge(json.optBoolean(JSONConstants.GRID_HASFIXCELLMERGE));
		meta.setHasSubDetail(json.optBoolean(JSONConstants.GRID_HASSUBDETAIL));
		meta.setHasTree(json.optBoolean(JSONConstants.GRID_HASTREE));
		meta.setShowRowHead(json.optBoolean(JSONConstants.GRID_SHOWROWHEAD));
		meta.setEndEditByNav(json.optBoolean(JSONConstants.GRID_ENDEDITBYNAV));
		meta.setDefaultFitWidth(json.optBoolean(JSONConstants.GRID_DEFAULTFITWIDTH));
		meta.setHideGroup4Editing(json.optBoolean(JSONConstants.GRID_HIDEGROUP4EDITING));
		meta.setMultiple(json.optBoolean(JSONConstants.GRID_MULTIPLE));
		meta.setNewEmptyRow(json.optString(JSONConstants.GRID_NEWEMPTYROW));
		meta.setSingleSelect(json.optBoolean(JSONConstants.GRID_SINGLESELECT));
		meta.setSelectIndex(json.optInt(JSONConstants.GRID_SELECTFIELDINDEX));
		meta.setTreeIndex(json.optInt(JSONConstants.GRID_TREEINDEX));
		meta.setRowExpandIndex(json.optInt(JSONConstants.GRID_ROWEXPANDINDEX));
		meta.setTopFixRowCount(json.optInt(JSONConstants.GRID_TOPFIXROWCOUNT));
		meta.setTotalFirst(json.optBoolean(JSONConstants.GRID_TOTALFIRST));
		meta.setBottomFixRowCount(json.optInt(JSONConstants.GRID_BOTTOMFIXROWCOUNT));
		meta.setEditRowFormKey(json.optString(JSONConstants.GRID_EDITROWFORMKEY));
		meta.setAddDataRow(json.optBoolean(JSONConstants.GRID_ADDDATAROW));
		if(!json.isNull(JSONConstants.GRID_SHOWTOTALROWCOUNT)) {
			meta.setShowTotalRowCount(json.optBoolean(JSONConstants.GRID_SHOWTOTALROWCOUNT));
		}
		JSONArray array = json.optJSONArray(JSONConstants.GRID_GROUPINDEXES);
		if( array != null ) {
			for( int i = 0,size = array.length();i < size;i++ ) {
				meta.addGroupIndex(array.optInt(i));
			}
		}

		array = json.optJSONArray(JSONConstants.GRID_MERGECELLKEYS);
		if( array != null ) {
			for( int i = 0,size = array.length();i < size;i++ ) {
				meta.addMergeCell(array.optString(i));
			}
		}

		array = json.optJSONArray(JSONConstants.GRID_TABLEKEYS);
		if( array != null ) {
			for( int i = 0,size = array.length();i < size;i++ ) {
				meta.addTableKey(array.optString(i));
			}
		}

		meta.setPageLoadType(json.optInt(JSONConstants.GRID_PAGELOADTYPE));
		meta.setPageRowCount(json.optInt(JSONConstants.GRID_PAGEROWCOUNT));
		meta.setPageIndicatorCount(json.optInt(JSONConstants.GRID_PAGEINDICATORCOUNT));
		meta.setFreezeRowCount(json.optInt(JSONConstants.GRID_FREEZEROWCNT));

		meta.setFreezeLeftColCount(json.optInt(JSONConstants.GRID_FREEZELEFTCOLCNT));
		meta.setFreezeRightColCount(json.optInt(JSONConstants.GRID_FREEZERIGHTCOLCNT));

		meta.setLocate(json.optBoolean(JSONConstants.GRID_LOCATE));
		meta.setSortable(json.optBoolean(JSONConstants.GRID_SORTABLE));
		meta.setDetailRowIndex(json.optInt(JSONConstants.GRID_DETAILMETAROWINDEX));
		meta.setSerialSeq(json.optBoolean(JSONConstants.GRID_SERIALSEQ));
		meta.setSerialRowNum(json.optBoolean(JSONConstants.GRID_SERIALROWNUM));
		meta.setRowRange(json.optString(JSONConstants.GRID_ROWRANGE));
		meta.setOption(json.optString(JSONConstants.GRID_OPTION));
		meta.setDisabledOption(json.optString(JSONConstants.GRID_DISABLEOPTION));
		meta.setSelectMode(json.optInt(JSONConstants.GRID_SELECTIONMODE));

		JSONObject o = json.optJSONObject(JSONConstants.GRID_LEAFINDEXMAP);
		@SuppressWarnings("unchecked")
		Set<String> keySet = o.keySet();
		for( String key : keySet ) {
			meta.addLeafRowIndex(key, o.optInt(key));
		}

		array = json.optJSONArray(JSONConstants.GRID_ROWS);
		if( array != null ) {
			MetaGridRowCollection rowCollection = new MetaGridRowCollection();
			List<MetaGridRow> list = UIJSONHandlerUtil.unbuild(MetaGridRow.class, array);
			rowCollection.addAll(0, list);
			meta.setRowCollection(rowCollection);
		}

		array = json.optJSONArray(JSONConstants.GRID_COLUMNS);
		if( array != null ) {
			MetaGridColumnCollection columnCollection = new MetaGridColumnCollection();
			List<MetaGridColumn> list = UIJSONHandlerUtil.unbuild(MetaGridColumn.class, array);
			columnCollection.addAll(0, list);
			meta.setColumnCollection(columnCollection);
		}

		o = json.optJSONObject(JSONConstants.GRID_AREAEXPAND);
		if( o != null ) {
			MetaRowAreaExpand areaExpand = UIJSONHandlerUtil.unbuild(MetaRowAreaExpand.class, o);
			meta.setRowAreaExpand(areaExpand);
		}


		o = json.optJSONObject(JSONConstants.GRID_FILTER);
		if( o != null ) {
			MetaGridFilter filter = UIJSONHandlerUtil.unbuild(MetaGridFilter.class, o);
			meta.setFilter(filter);
		}

		array = json.optJSONArray(JSONConstants.GRID_TRACES);
		if( array != null ) {
			MetaTraceCollection tcs = new MetaTraceCollection();
			List<MetaTrace> list = UIJSONHandlerUtil.unbuild(MetaTrace.class, array);
			tcs.addAll(0, list);
			meta.setTraceCollection(tcs);
		}

		array = json.optJSONArray(JSONConstants.GRID_EXTOPTS);
		if( array != null ) {
			MetaExtOptCollection eoc = new MetaExtOptCollection();
			List<MetaExtOpt> list = UIJSONHandlerUtil.unbuild(MetaExtOpt.class, array);
			eoc.addAll( list);
			meta.setExtOpts(eoc);
		}

		String s = json.optString(JSONConstants.Event_RowClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowClick);
			script.setContent(s);
			meta.setRowClick(script);
		}
		s = json.optString(JSONConstants.Event_FocusRowChanged);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_FocusRowChanged);
			script.setContent(s);
			meta.setFocusRowChanged(script);
		}
		s = json.optString(JSONConstants.Event_RowDblClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowDblClick);
			script.setContent(s);
			meta.setRowDblClick(script);
		}
		s = json.optString(JSONConstants.Event_BeforeRowInsert);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(JSONConstants.Event_BeforeRowInsert);
			script.setContent(s);
			meta.setBeforeRowInsert(script);
		}
		s = json.optString(JSONConstants.Event_RowInsert);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowInsert);
			script.setContent(s);
			meta.setRowInsert(script);
		}
		s = json.optString(JSONConstants.Event_RowDelete);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowDelete);
			script.setContent(s);
			meta.setRowDelete(script);
		}
	}
	@Override
	public void toJSONImpl(JSONObject json, MetaGrid meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);

		JSONHelper.writeToJSON(json, JSONConstants.GRID_SORT, meta.getGridDefaultSortField());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_HASCOLEXPAND, meta.hasColumnExpand());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_HASCELLEXPAND, meta.hasCellExpand());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_HASROWEXPAND, meta.hasRowExpand());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_HASROWAREAEXPAND, meta.hasRowAreaExpand());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_HASROWGROUP, meta.hasRowGroup());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_HASFIXROW, meta.hasFixRow());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_HASTOTALROW, meta.hasTotalRow());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_HASFIXCELLMERGE, meta.hasFixCellMerge());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_HASDETAILROW, meta.hasDetailRow());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_HASDETAILCELLMERGE, meta.hasDetailCellMerge());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_HASSUBDETAIL, meta.hasSubDetail());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_HASTREE, meta.hasTree());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_TOTALFIRST, meta.totalFirst());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_SHOWROWHEAD, meta.isShowRowHead());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ENDEDITBYNAV, meta.isEndEditByNav());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_DEFAULTFITWIDTH, meta.getDefaultFitWidth());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_HIDEGROUP4EDITING, meta.isHideGroup4Editing());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_MULTIPLE, meta.isMultiple());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_NEWEMPTYROW, meta.getNewEmptyRow());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_SINGLESELECT, meta.singleSelect());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_SELECTFIELDINDEX, meta.getSelectIndex());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_TREEINDEX, meta.getTreeIndex());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ROWEXPANDINDEX, meta.getRowExpandIndex());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_TOPFIXROWCOUNT, meta.getTopFixRowCount());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_BOTTOMFIXROWCOUNT, meta.getBottomFixRowCount());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_EDITROWFORMKEY, meta.getEditRowFormKey());
		JSONHelper.writeToJSON(json, JSONConstants.PRIMARYKEYS, meta.getPrimaryKeys());

		// List
		JSONHelper.writeToJSON(json, JSONConstants.GRID_GROUPINDEXES, meta.getGroupIndexes());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_GROUPCELLS, meta.getGroupCells());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_MERGECELLKEYS, meta.getMergeCells());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_TABLEKEYS, meta.getTableKeys());

		JSONHelper.writeToJSON(json, JSONConstants.GRID_PAGELOADTYPE, meta.getPageLoadType());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_PAGEROWCOUNT, meta.getPageRowCount());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_PAGEINDICATORCOUNT, meta.getPageIndicatorCount());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_FREEZEROWCNT, meta.getFreezeRowCount());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_FREEZELEFTCOLCNT, meta.getFreezeLeftColCount());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_FREEZERIGHTCOLCNT, meta.getFreezeRightColCount());

		JSONHelper.writeToJSON(json, JSONConstants.GRID_ROWRANGE, meta.getRowRange());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_OPTION, meta.getOption());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_DISABLEOPTION, meta.getDisabledOption());

		JSONHelper.writeToJSON(json, JSONConstants.GRID_ROWLAYER, initRowLayer(meta));

		JSONHelper.writeToJSON(json, JSONConstants.GRID_LOCATE, meta.getLocate());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_SORTABLE, meta.getSortable());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_DETAILMETAROWINDEX, meta.getDetailMetaRowIndex());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_SERIALSEQ, meta.isSerialSeq());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_SERIALROWNUM, meta.isSerialRowNum());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_SELECTIONMODE, meta.getSelectMode());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_SHOWTOTALROWCOUNT, meta.isShowTotalRowCount());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ADDDATAROW, meta.getAddDataRow());

		JSONObject leafIndexMapObj = new JSONObject();
		Map<String, Integer> map = meta.getLeafIndexMap();
		Iterator<String> it = map.keySet().iterator();
		while (it.hasNext()) {
			String key = it.next();
			leafIndexMapObj.put(key, map.get(key));
		}

		JSONHelper.writeToJSON(json, JSONConstants.GRID_LEAFINDEXMAP, leafIndexMapObj);

		MetaGridRow detailRow = meta.getDetailMetaRow();
		if( detailRow != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.GRID_DETAILKEY, detailRow.getKey());
		}

		MetaRowTree rowTree = null;
		if( detailRow != null ) {
			rowTree = detailRow.getRowTree();
		}
		if( rowTree != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.GRID_TREETYPE, rowTree.getTreeType());
			JSONHelper.writeToJSON(json, JSONConstants.GRID_TREEEXPAND, rowTree.isExpand());
		}
		MetaGrid metaGrid = meta.sortGrid();
		// 行
		MetaGridRowCollection rowCollection = metaGrid.getRowCollection();
		MetaGridColumnCollection columnCollection = metaGrid.getColumnCollection();
		JSONArray rowArray = UIJSONHandlerUtil.buildNoKeyCollection(hook, rowCollection);
		JSONHelper.writeToJSON(json, JSONConstants.GRID_ROWS, rowArray);

		// 列



		JSONArray colArray = UIJSONHandlerUtil.buildNoKeyCollection(hook, columnCollection);
		JSONHelper.writeToJSON(json, JSONConstants.GRID_COLUMNS, colArray);

		// 行区域拓展
		MetaRowAreaExpand areaExpand = meta.getRowAreaExpand();
		if( areaExpand != null ) {
			JSONObject o = UIJSONHandlerUtil.build(areaExpand,hook);
			JSONHelper.writeToJSON(json, JSONConstants.GRID_AREAEXPAND, o);
		}

		String rowRange = meta.getRowRange();
		if( rowRange != null && !rowRange.trim().isEmpty() ) {
			JSONArray rowList = new JSONArray();
			String[] arr = rowRange.split(",");
			for( int i = 0,length = arr.length;i < length;i++ ) {
				rowList.put(Integer.parseInt(arr[i].trim()));
			}
			JSONHelper.writeToJSON(json, JSONConstants.GRID_ROWLIST, rowList);
		}

		MetaGridFilter filter = meta.getFilter();
		if( filter != null ) {
			JSONObject o = UIJSONHandlerUtil.build(filter,hook);
			JSONHelper.writeToJSON(json, JSONConstants.GRID_FILTER, o);
		}

		MetaTraceCollection tcs = meta.getTraceCollection();
		if( tcs != null ) {
			JSONArray array = UIJSONHandlerUtil.buildNoKeyCollection(hook, tcs);
			JSONHelper.writeToJSON(json, JSONConstants.GRID_TRACES, array);
		}

		MetaExtOptCollection eoc = meta.getExtOpts();
		if( eoc != null ) {
			JSONArray opts = UIJSONHandlerUtil.buildKeyCollection(hook, eoc);
			JSONHelper.writeToJSON(json, JSONConstants.GRID_EXTOPTS, opts);
		}

		String option = meta.getOption();
		if( option != null && !option.isEmpty() ) {
			String[] options = option.split(",");
			JSONArray array = new JSONArray();
			for( String opt : options ) {
				array.put(opt);
			}
			JSONHelper.writeToJSON(json, JSONConstants.GRID_OPTS, array);
		}

		String disableOption = meta.getDisabledOption();
		if( disableOption != null && !disableOption.isEmpty() ) {
			String[] disableOptions = disableOption.split(",");
			JSONArray array = new JSONArray();
			for( String opt : disableOptions ) {
				array.put(opt);
			}
			JSONHelper.writeToJSON(json, JSONConstants.GRID_DISABLEOPTS, array);
		}

		//行单击事件
		MetaBaseScript rowClick = meta.getRowClick();
		if(rowClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowClick, rowClick.getContent());
		}

		//行切换事件
		MetaBaseScript focusRowChanged = meta.getFocusRowChanged();
		if(focusRowChanged != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_FocusRowChanged, focusRowChanged.getContent());
		}

		//行双击事件
		MetaBaseScript rowDbClick = meta.getRowDblClick();
		if(rowDbClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowDblClick, rowDbClick.getContent());
		}

		//行增加前事件
		MetaBaseScript beforeRowInsert = meta.getBeforeRowInsert();
		if( beforeRowInsert != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_BeforeRowInsert, beforeRowInsert.getContent());
		}

		//行增加事件
		MetaBaseScript rowInsert = meta.getRowInsert();
		if( rowInsert != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowInsert, rowInsert.getContent());
		}

		//行删除后事件
		MetaBaseScript rowDelete = meta.getRowDelete();
		if( rowDelete != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowDelete, rowDelete.getContent());
		}

		//行删除事件
		MetaBaseScript onRowDelete = meta.getOnRowDelete();
		if( onRowDelete != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnRowDelete, onRowDelete.getContent(), "");
		}

		// 表格自身数据依赖
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DEPENDENCY, String.join(",", meta.getOwnerDepFields()));
	}


	private JSONObject initRowLayer(MetaGrid metaGrid) {
		JSONObject rowLayerObj = new JSONObject();
		MetaGridRowLayer rowLayer = metaGrid.getRowLayer();
		JSONArray array = new JSONArray();
		for (int i = 0,size = rowLayer.getObjectCount();i < size; i++) {
			array.put(rowObj2JSON(metaGrid, rowLayer.getObject(i)));
		}
		rowLayerObj.put("areaIndex", rowLayer.getAreaIndex());
		return rowLayerObj.put("objectArray", array);
	}

	private JSONObject rowObj2JSON(MetaGrid metaGrid, IMetaGridRowObject rowObj) {
		JSONObject json = new JSONObject();
		int objectType = rowObj.getObjectType();
		json.put("objectType", objectType);
		if( objectType == IMetaGridRowObject.Group || objectType == IMetaGridRowObject.Area ) {
			JSONArray array = new JSONArray();
			for (int i = 0,size = rowObj.getObjectCount(); i < size; i++) {
				array.put(rowObj2JSON(metaGrid, rowObj.getObject(i)));
			}
			json.put("objectArray", array);
		} else {
			MetaGridRow metaRow = (MetaGridRow)rowObj;
			json.put("key", metaRow.getKey());
			json.put("rowIndex", metaGrid.getRowCollection().indexOf(metaRow));
		}
		return json;
	}

	@Override
	public MetaGrid newInstance() {
		return new MetaGrid();
	}

}