package com.bokesoft.yes.meta.json.com.grid;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.form.MetaBaseScriptJSONHandler;
import com.bokesoft.yigo.meta.form.component.grid.MetaColumnExpand;

public class MetaColumnExpandJSONHandler extends MetaBaseScriptJSONHandler<MetaColumnExpand,DefaultSerializeContext>{

	@Override
	public void toJSONImpl(JSONObject json, MetaColumnExpand meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		
		JSONHelper.writeToJSON(json, JSONConstants.GRID_EXPANDTYPE, meta.getExpandType());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_EXPANDSOURCETYPE, meta.getExpandSourceType());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_TABLEKEY, meta.getTableKey());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_COLUMNKEY, meta.getColumnKey());
		JSONHelper.writeToJSON(json, JSONConstants.DICT_ITEMKEY, meta.getItemKey());
		JSONHelper.writeToJSON(json, JSONConstants.GRID_EXPANDDEPENDENCY, meta.getExpandDependency());
	}
	
	@Override
	public void fromJSONImpl(MetaColumnExpand meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		
		meta.setExpandType(json.optInt(JSONConstants.GRID_EXPANDTYPE));
		meta.setExpandSourceType(json.optInt(JSONConstants.GRID_EXPANDSOURCETYPE));
		meta.setTableKey(json.optString(JSONConstants.GRID_TABLEKEY));
		meta.setColumnKey(json.optString(JSONConstants.GRID_COLUMNKEY));
		meta.setItemKey(json.optString(JSONConstants.DICT_ITEMKEY));
		meta.setExpandDependency(json.optString(JSONConstants.GRID_EXPANDDEPENDENCY));
	}
	
	@Override
	public MetaColumnExpand newInstance() {
		return new MetaColumnExpand();
	}

}
