package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.MetaWebBrowser;

public class MetaWebBrowserJSONHandler extends BaseComponentJSONHandler<MetaWebBrowser> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaWebBrowser meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.WEBBROWSER_URLPREFIX, meta.getUrlPrefix());
		JSONHelper.writeToJSON(json, JSONConstants.WEBBROWSER_SOURCETYPE,meta.getSourceType());
	}
	
	@Override
	public void fromJSONImpl(MetaWebBrowser meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setUrlPrefix(json.optString(JSONConstants.WEBBROWSER_URLPREFIX));
		meta.setSourceType(json.optInt(JSONConstants.WEBBROWSER_SOURCETYPE));
	}

	@Override
	public MetaWebBrowser newInstance() {
		return new MetaWebBrowser();
	}
}
