package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.bar.MetaToolBar;
import com.bokesoft.yigo.meta.form.component.bar.MetaToolBarItemCollection;

public class MetaToolBarJSONHandler extends BaseComponentJSONHandler<MetaToolBar> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaToolBar meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.TOOLBAR_ISDEFAULT, meta.getIsDefault());
		
		if(meta.getItemCollection() != null){
			JSONArray itemArray = UIJSONHandlerUtil.buildNoKeyCollection(hook, meta.getItemCollection());
			json.put(JSONConstants.COMMON_ITEMS, itemArray);
		}
	}
	
	@Override
	public void fromJSONImpl(MetaToolBar meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setIsDefault(json.optBoolean(JSONConstants.TOOLBAR_ISDEFAULT));
		
		JSONArray itemArray = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if(itemArray != null){
			MetaToolBarItemCollection itemCollection = new MetaToolBarItemCollection();
			for( int i = 0,size = itemArray.length();i < size;i++ ) {
				JSONObject o = itemArray.optJSONObject(i);
				MetaComponent child = (MetaComponent) UIJSONHandlerUtil.unbuild(o);
				itemCollection.add(child);
			}
			meta.setItemCollection(itemCollection);
		}
	}

	@Override
	public MetaToolBar newInstance() {
		return new MetaToolBar();
	}
}
