package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import com.bokesoft.yigo.meta.form.component.control.MetaTabItem;

public class MetaTabItemJSONHandler extends AbstractJSONHandler<MetaTabItem,DefaultSerializeContext>{
	
	@Override
	public void toJSONImpl(JSONObject json, MetaTabItem meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey());
		String text = hook.getString(GroupKeyTable.STR_UI, "", meta.getKey(), meta.getText());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TEXT, text);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMKEY, meta.getFormKey());
		JSONHelper.writeToJSON(json, JSONConstants.TABGROUP_ITEM_SELECTEDICON, meta.getSelectedIcon());
		JSONHelper.writeToJSON(json, JSONConstants.TABGROUP_ITEM_CLICKANIM, meta.getClickAnim());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VISIBLE, meta.getVisible());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_VISIBLEDEPENDENCY, meta.getVisibleDependency());
		
		MetaBaseScript action = meta.getAction();
		if( action != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.TABGROUP_ACTION, action.getContent());		
		}

		MetaBaseScript onClick = meta.getOnClick();
		if( onClick != null ) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent());		
		}
		
		MetaFormat format = meta.getFormat();
		if( format != null ) {
			JSONObject o = UIJSONHandlerUtil.build(format,hook);
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMAT, o);
		}
	}

	@Override
	public void fromJSONImpl(MetaTabItem meta, JSONObject json) throws Throwable {
		meta.setKey(json.optString(JSONConstants.COMMON_KEY));
		meta.setText(json.optString(JSONConstants.COMMON_TEXT));
		meta.setIcon(json.optString(JSONConstants.COMMON_ICON));
		meta.setFormKey(json.optString(JSONConstants.COMMON_FORMKEY));
		meta.setSelectedIcon(json.optString(JSONConstants.TABGROUP_ITEM_SELECTEDICON));
		meta.setClickAnim(json.optString(JSONConstants.TABGROUP_ITEM_CLICKANIM));
		meta.setVisible(json.optString(JSONConstants.COMMON_VISIBLE));
		meta.setVisibleDependency(json.optString(JSONConstants.COMMON_VISIBLEDEPENDENCY));
		
		String s = json.optString(JSONConstants.TABGROUP_ACTION);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_Action);
			script.setContent(s);
			meta.setAction(script);
		}

		s = json.optString(JSONConstants.Event_OnClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
			script.setContent(s);
			meta.setOnClick(script);
		}
		
		JSONObject o = json.optJSONObject(JSONConstants.COMMON_FORMAT);
		if( o != null ) {
			MetaFormat format = UIJSONHandlerUtil.unbuild(MetaFormat.class, o);
			meta.setFormat(format);
		}
	}

	@Override
	public MetaTabItem newInstance() {
		return new MetaTabItem();
	}

}
