package com.bokesoft.yes.meta.json.com.comp;


import org.json.JSONObject;
import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import com.bokesoft.yigo.meta.form.component.control.refresh.MetaRefreshState;

public class MetaRefreshStateJSONHandler extends AbstractJSONHandler<MetaRefreshState,DefaultSerializeContext>{

	@Override
	public MetaRefreshState newInstance() {
		return new MetaRefreshState();
	}

	@Override
	public void fromJSONImpl(MetaRefreshState meta, JSONObject json) throws Throwable {
		JSONObject object = json.optJSONObject(JSONConstants.COMMON_FORMAT);
		if (object!=null) {
			meta.setFormat(UIJSONHandlerUtil.unbuild(MetaFormat.class,object));
		}
		meta.setIcon(json.optString(JSONConstants.COMMON_ICON));
		meta.setText(json.optString(JSONConstants.COMMON_TEXT));
		meta.setIconLocation(json.optInt(JSONConstants.REFRESHCONTROL_ICONLOCATION));
		meta.setType(json.optInt(JSONConstants.REFRESHCONTROL_TYPE));
	}

	@Override
	public void toJSONImpl(JSONObject json, MetaRefreshState meta, DefaultSerializeContext hook) throws Throwable {
		MetaFormat format = meta.getFormat();
		if (format != null) {
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMAT,UIJSONHandlerUtil.build(format,hook));
		}
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ICON, meta.getIcon());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TEXT, meta.getText());
		JSONHelper.writeToJSON(json, JSONConstants.REFRESHCONTROL_ICONLOCATION, meta.getIconLocation());
		JSONHelper.writeToJSON(json, JSONConstants.REFRESHCONTROL_TYPE, meta.getType());
	}
}
