package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressBarItem;

public class MetaProgressBarItemJSONHandler extends AbstractJSONHandler<MetaProgressBarItem,DefaultSerializeContext> {

	@Override
	public void toJSONImpl(JSONObject json, MetaProgressBarItem meta, DefaultSerializeContext hook)
			throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBARITEM_ENDPOS, meta.getEndPos());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBARITEM_STARTPOS, meta.getStartPos());
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBARITEM_COLOR, meta.getColor());
		
		
	}

	@Override
	public void fromJSONImpl(MetaProgressBarItem meta, JSONObject json) throws Throwable {
		meta.setEndPos(json.optInt(JSONConstants.PROGRESSBARITEM_ENDPOS));
		meta.setStartPos(json.optInt(JSONConstants.PROGRESSBARITEM_STARTPOS));
		meta.setColor(json.optString(JSONConstants.PROGRESSBARITEM_COLOR));
	}
	
	@Override
	public MetaProgressBarItem newInstance() {
		return new MetaProgressBarItem();
	}
}
