package com.bokesoft.yes.meta.json.com.comp;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yigo.meta.form.component.control.MetaFontPicker;

public class MetaFontPickerJSONHandler extends BaseComponentJSONHandler<MetaFontPicker>{
	
	@Override
	public void toJSONImpl(JSONObject json, MetaFontPicker meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.FONTPICKER_INITFONTNAME, meta.getInitFontName());
		JSONHelper.writeToJSON(json, JSONConstants.FONTPICKER_INITFONTSIZE, meta.getInitFontSize());
	}

	@Override
	public MetaFontPicker newInstance() {
		return new MetaFontPicker();
	}
	
}
