package com.bokesoft.yes.meta.json.com.comp;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.dictview.MetaDictView;
import com.bokesoft.yigo.meta.form.component.control.dictview.MetaDictViewColumn;
import com.bokesoft.yigo.meta.form.component.control.dictview.MetaDictViewColumnCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;

public class MetaDictViewJSONHandler extends BaseComponentJSONHandler<MetaDictView> {

	@Override
	public void fromJSONImpl(MetaDictView meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);

		meta.setFormulaItemKey(json.optString(JSONConstants.DICTVIEW_FORMULAITEMKEY));
		meta.setPageRowCount(json.optInt(JSONConstants.DICTVIEW_PAGEROWCOUNT));
		meta.setOnlyExpand(json.optBoolean(JSONConstants.DICTVIEW_ONLYEXPAND));
		meta.setShowTitle(json.optBoolean(JSONConstants.DICTVIEW_SHOWTITLE));
		meta.setLoadType(json.optInt(JSONConstants.DICT_LOADTYPE));

		String s = json.optString(JSONConstants.Event_RowClick);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowClick);
			script.setContent(s);
			meta.setRowClick(script);
		}

		s = json.optString(JSONConstants.Event_RowDblClick);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_RowDblClick);
			script.setContent(s);
			meta.setRowDblClick(script);
		}

		s = json.optString(JSONConstants.Event_FocusRowChanged);
		if (s != null && !s.isEmpty()) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_FocusRowChanged);
			script.setContent(s);
			meta.setFocusRowChanged(script);
		}

		JSONObject o = json.optJSONObject(JSONConstants.DICT_ITEMFILTERS);
		if (o != null) {
			MetaItemFilterCollection collection = UIJSONHandlerUtil.unbuild(MetaItemFilterCollection.class, o);
			meta.setFilters(collection);
		}

		JSONArray array = json.optJSONArray(JSONConstants.DICTVIEW_COLUMNS);
		if (array != null) {
			MetaDictViewColumnCollection columns = new MetaDictViewColumnCollection();
			List<MetaDictViewColumn> list = UIJSONHandlerUtil.unbuild(MetaDictViewColumn.class, array);
			columns.addAll(list);
			meta.setColumnCollection(columns);
		}
	}

	@Override
	public void toJSONImpl(JSONObject json, MetaDictView meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);

		json.put(JSONConstants.DICTVIEW_FORMULAITEMKEY, meta.getFormulaItemKey());
		json.put(JSONConstants.DICTVIEW_PAGEROWCOUNT, meta.getPageRowCount());
		json.put(JSONConstants.DICTVIEW_ONLYEXPAND, meta.getOnlyExpand());
		json.put(JSONConstants.DICTVIEW_SHOWTITLE, meta.getShowTitle());
		json.put(JSONConstants.DICT_LOADTYPE, meta.getLoadType());

		MetaBaseScript rowClick = meta.getRowClick();
		if (rowClick != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowClick, rowClick.getContent().trim());
		}

		MetaBaseScript rowDblClick = meta.getRowDblClick();
		if (rowDblClick != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_RowDblClick, rowDblClick.getContent().trim());
		}

		MetaBaseScript focusRowChanged = meta.getFocusRowChanged();
		if (focusRowChanged != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_FocusRowChanged, focusRowChanged.getContent().trim());
		}

		MetaItemFilterCollection filters = meta.getFilters();
		if (filters != null) {
			JSONObject o = UIJSONHandlerUtil.build(filters,hook);
			JSONHelper.writeToJSON(json, JSONConstants.DICT_ITEMFILTERS, o);

			// 额外属性
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_FORMKEY, hook.getFormKey());
			JSONHelper.writeToJSON(json, JSONConstants.COMMON_FIELDKEY, meta.getKey());
		}

		MetaDictViewColumnCollection dvCols = meta.getColumnCollection();
		if (dvCols != null) {
			JSONArray array = UIJSONHandlerUtil.buildKeyCollection(hook, dvCols);
			JSONHelper.writeToJSON(json, JSONConstants.DICTVIEW_COLUMNS, array);
		}
	}

	@Override
	public MetaDictView newInstance() {
		return new MetaDictView();
	}

}
