package com.bokesoft.yes.meta.json.com.comp;

import java.util.Iterator;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.BaseComponentJSONHandler;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.ISerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.CarouselSourceType;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.MetaCarousel;
import com.bokesoft.yigo.meta.form.component.control.MetaDefaultItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCarouselItemCollection;

public class MetaCarouselJSONHandler extends BaseComponentJSONHandler<MetaCarousel> {
	
	@Override
	public void toJSONImpl(JSONObject json, MetaCarousel meta, DefaultSerializeContext hook)
			throws Throwable {
		super.toJSONImpl(json, meta, hook);
		JSONHelper.writeToJSON(json, JSONConstants.CAROUSEL_SOURCETYPE, meta.getSourceType());
		if(meta.isShowDots() != null) {
			JSONHelper.writeToJSON(json, JSONConstants.CAROUSEL_SHOWDOTS,meta.isShowDots());
		}
		
		if(meta.isAutoplay() != null) {
			JSONHelper.writeToJSON(json, JSONConstants.CAROUSEL_AUTOPLAY, meta.isAutoplay());
		}
		JSONHelper.writeToJSON(json, JSONConstants.CAROUSEL_AUTOPLAYINTERVAL,meta.getAutoplayInterval());
		
		JSONHelper.writeToJSON(json, JSONConstants.CAROUSEL_INFINITE,meta.isInfinite());
		
		switch(meta.getSourceType()){
			case CarouselSourceType.ITEMS:
				MetaCarouselItemCollection metaItems = meta.getItems();
				if( metaItems != null ) {
					JSONArray array = buildCommonItems(hook, metaItems);					
					JSONHelper.writeToJSON(json, JSONConstants.CAROUSEL_ITEMS, array);
				}
			break;
			case CarouselSourceType.FORMULA: 
				MetaBaseScript formulaItems = meta.getFormulaItems();
				if( formulaItems != null ) {
					JSONHelper.writeToJSON(json, JSONConstants.CAROUSEL_FORMULAITEMS, formulaItems.getContent().trim());
				}
			break;
		}
		
		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent().trim());
		}

		
	}
	
	private JSONArray buildCommonItems(ISerializeContext hook, MetaCarouselItemCollection metaItems) throws Throwable {
		JSONArray array = new JSONArray();
		Iterator<MetaDefaultItem> it = metaItems.iterator();
		while ( it.hasNext() ) {
			MetaDefaultItem metaItem = it.next();
			JSONObject itemJSON = new JSONObject();
			JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_KEY, metaItem.getKey());
			JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_CAPTION, metaItem.getCaption());
			JSONHelper.writeToJSON(itemJSON, JSONConstants.COMMON_VALUE, metaItem.getValue());
			array.put(itemJSON);
		}
		return array;
	}
	
	
	@Override
	public void fromJSONImpl(MetaCarousel meta, JSONObject json) throws Throwable {
		super.fromJSONImpl(meta, json);
		meta.setSourceType(json.optInt(JSONConstants.CAROUSEL_SOURCETYPE));
		
		meta.setShowDots(json.optBoolean(JSONConstants.CAROUSEL_SHOWDOTS));
		meta.setAutoplay(json.optBoolean(JSONConstants.CAROUSEL_AUTOPLAY));
		meta.setAutoplayInterval(json.optInt(JSONConstants.CAROUSEL_AUTOPLAYINTERVAL, -1));
		meta.setInfinite(json.optBoolean(JSONConstants.CAROUSEL_INFINITE));
		
		int sourceType = meta.getSourceType();
		if( sourceType == CarouselSourceType.ITEMS) {
			JSONArray array = json.optJSONArray(JSONConstants.CAROUSEL_ITEMS);
			if( array != null ) {
				MetaCarouselItemCollection metaItems = new MetaCarouselItemCollection();
				List<MetaDefaultItem> list = UIJSONHandlerUtil.unbuild(MetaDefaultItem.class, array);
				metaItems.addAll(0, list);
				meta.setItems(metaItems);
			}
		}else if(sourceType == CarouselSourceType.FORMULA) {
			String s = json.optString(JSONConstants.CAROUSEL_FORMULAITEMS);
			if (s != null && !s.isEmpty()) {
				MetaBaseScript script = new MetaBaseScript(MetaConstants.CAROUSEL_FORMULAITEMS);
				script.setContent(s);
				meta.setFormulaItems(script);
			}
		}
		
		String s = json.optString(JSONConstants.Event_OnClick);
		if( s != null && !s.isEmpty() ) {
			MetaBaseScript script = new MetaBaseScript(MetaConstants.Event_OnClick);
			script.setContent(s);
			meta.setOnClick(script);
		}
	}

	@Override
	public MetaCarousel newInstance() {
		return new MetaCarousel();
	}
}
