package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.timer.action.TimerWorkitemCommit;

public class TimerWorkitemCommitJSONHandler extends AbstractJSONHandler<TimerWorkitemCommit, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(TimerWorkitemCommit meta, JSONObject json) throws Throwable {
		meta.setParticipatorFormula(json.optString(JSONConstants.TIMER_PARTCIPAOR_FORMULA));
		meta.setResult(json.optInt(JSONConstants.TIMER_RESULT));
		meta.setUserInfo(json.optString(JSONConstants.TIMER_USER_INFO));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, TimerWorkitemCommit meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.TIMER_PARTCIPAOR_FORMULA, meta.getParticipatorFormula());
		JSONHelper.writeToJSON(json, JSONConstants.TIMER_RESULT, meta.getResult());
		JSONHelper.writeToJSON(json, JSONConstants.TIMER_USER_INFO, meta.getUserInfo());
		
	}
	
	@Override
	public TimerWorkitemCommit newInstance() {
		return new TimerWorkitemCommit();
	}
}
