package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlineSize;

public class MetaSwimlineSizeJSONHandler extends AbstractJSONHandler<MetaSwimlineSize, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaSwimlineSize meta, JSONObject json) throws Throwable {
		meta.setHeight(json.optInt(JSONConstants.BPM_HEIGHT));
		meta.setWidth(json.optInt(JSONConstants.BPM_WIDTH));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaSwimlineSize meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.BPM_HEIGHT, meta.getHeight());
		JSONHelper.writeToJSON(json, JSONConstants.BPM_WIDTH, meta.getWidth());
		
	}
	
	@Override
	public MetaSwimlineSize newInstance() {
		return new MetaSwimlineSize();
	}
}
