package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourcePara;

public class MetaSourceParaJSONHandler extends AbstractJSONHandler<MetaSourcePara, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaSourcePara meta, JSONObject json) throws Throwable {
		meta.setParaKey(json.optString(JSONConstants.PARTICIPATOR_PARA_KEY));
		meta.setParaValue(json.optString(JSONConstants.PARTICIPATOR_PARA_VALUE));
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaSourcePara meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		JSONHelper.writeToJSON(json, JSONConstants.PARTICIPATOR_PARA_KEY, meta.getParaKey());
		JSONHelper.writeToJSON(json, JSONConstants.PARTICIPATOR_PARA_VALUE, meta.getParaValue());
		
	}
	
	@Override
	public MetaSourcePara newInstance() {
		return new MetaSourcePara();
	}
}
