package com.bokesoft.yes.meta.json.bpm;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.meta.json.AbstractJSONHandler;
import com.bokesoft.yes.meta.json.BPMSerializeContext;
import com.bokesoft.yes.meta.json.util.BPMJSONHandlerUtil;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourcePara;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaSourceParaCollection;

public class MetaSourceParaCollectionJSONHandler extends AbstractJSONHandler<MetaSourceParaCollection, BPMSerializeContext> {

	@Override
	public void fromJSONImpl(MetaSourceParaCollection meta, JSONObject json) throws Throwable {
		JSONArray array = json.optJSONArray(JSONConstants.COMMON_ITEMS);
		if(array != null){
			meta.addAll(0, BPMJSONHandlerUtil.unbuild(MetaSourcePara.class, array));
		}
		
	}
	
	@Override
	public void toJSONImpl(JSONObject json, MetaSourceParaCollection meta, BPMSerializeContext hook) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.BPM_TAGNAME, meta.getTagName());
		
		JSONArray array = BPMJSONHandlerUtil.buildNoKeyCollection(hook, meta);
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_ITEMS, array);
		
	}
	
	@Override
	public MetaSourceParaCollection newInstance() {
		return new MetaSourceParaCollection();
	}
}
